(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[1],{141:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.retrieveMorphologyData = undefined;\n\n/**\n * Retrieves the morphology data.\n *\n * @param {Object} settings The indexation settings.\n *\n * @returns {Promise} The morphology data promise.\n */\nvar retrieveMorphologyData = exports.retrieveMorphologyData = function () {\n\tvar _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(settings) {\n\t\tvar morphologyData, url, siteUrl;\n\t\treturn regeneratorRuntime.wrap(function _callee$(_context) {\n\t\t\twhile (1) {\n\t\t\t\tswitch (_context.prev = _context.next) {\n\t\t\t\t\tcase 0:\n\t\t\t\t\t\tmorphologyData = getMorphologyData();\n\n\t\t\t\t\t\t// Load morphology data only once and if it\'s supported.\n\n\t\t\t\t\t\tif (!(morphologyData || !settings.morphologySupported)) {\n\t\t\t\t\t\t\t_context.next = 3;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn _context.abrupt("return", Promise.resolve());\n\n\t\t\t\t\tcase 3:\n\t\t\t\t\t\turl = (0, _determineMorphologyRequestUrl.determineMorphologyRequestUrl)(settings.language || "en");\n\n\t\t\t\t\t\tif (!(url === false)) {\n\t\t\t\t\t\t\t_context.next = 6;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn _context.abrupt("return", Promise.resolve());\n\n\t\t\t\t\tcase 6:\n\t\t\t\t\t\tsiteUrl = (0, _lodash.get)(window, "wpseoPremiumIndexationData.licensedURL", "");\n\n\t\t\t\t\t\t// eslint-disable-next-line require-atomic-updates\n\n\t\t\t\t\t\t_context.next = 9;\n\t\t\t\t\t\treturn doAjaxRequest("GET", url, null, {\n\t\t\t\t\t\t\t// Disable reason: this is how it is done in PHP (see MyYoast proxy).\n\t\t\t\t\t\t\tplugin_version: _package2.default.yoast.pluginVersion, // eslint-disable-line camelcase\n\t\t\t\t\t\t\tsite: siteUrl\n\t\t\t\t\t\t});\n\n\t\t\t\t\tcase 9:\n\t\t\t\t\t\tmorphologyData = _context.sent;\n\n\n\t\t\t\t\t\tsetMorphologyData(morphologyData);\n\t\t\t\t\t\treturn _context.abrupt("return", Promise.resolve(morphologyData));\n\n\t\t\t\t\tcase 12:\n\t\t\t\t\tcase "end":\n\t\t\t\t\t\treturn _context.stop();\n\t\t\t\t}\n\t\t\t}\n\t\t}, _callee, this);\n\t}));\n\n\treturn function retrieveMorphologyData(_x) {\n\t\treturn _ref.apply(this, arguments);\n\t};\n}();\n\nexports.setMorphologyData = setMorphologyData;\nexports.getMorphologyData = getMorphologyData;\nexports.extractProminentWords = extractProminentWords;\nexports.generateProminentWords = generateProminentWords;\n\nvar _lodash = __webpack_require__(2);\n\nvar _yoastseo = __webpack_require__(18);\n\nvar _currentWindowResearcherFactory = __webpack_require__(142);\n\nvar _currentWindowResearcherFactory2 = _interopRequireDefault(_currentWindowResearcherFactory);\n\nvar _package = __webpack_require__(41);\n\nvar _package2 = _interopRequireDefault(_package);\n\nvar _compressWordsForLinking = __webpack_require__(42);\n\nvar _determineMorphologyRequestUrl = __webpack_require__(43);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }\n\n// Yoast SEO free dependencies.\nvar doAjaxRequest = window.yoast.editorModules.helpers.ajaxHelper.doAjaxRequest;\n\n\nvar _morphologyData = false;\n\n/**\n * Sets the morphology data.\n *\n * @param {object} morphologyData The morphology data.\n *\n * @returns {void}\n */\nfunction setMorphologyData(morphologyData) {\n\t_morphologyData = morphologyData;\n}\n\n/**\n * Gets the morphology data.\n *\n * @returns {object} The morphology data.\n */\nfunction getMorphologyData() {\n\treturn _morphologyData;\n}\n\n/**\n * Extracts the prominent words from the given paper.\n *\n * @param {Paper}  paper             The paper.\n * @param {number} perIndexableLimit Maximum number of prominent words to extract.\n *\n * @returns {Object} The prominent words.\n */\nfunction extractProminentWords(paper, perIndexableLimit) {\n\tvar researcher = _currentWindowResearcherFactory2.default.create(paper);\n\n\tvar morphologyData = getMorphologyData();\n\tif (morphologyData) {\n\t\tresearcher.addResearchData("morphology", morphologyData);\n\t}\n\n\tvar research = researcher.getResearch("getProminentWordsForInternalLinking");\n\treturn (0, _compressWordsForLinking.compressWordsForLinking)(research.prominentWords.slice(0, perIndexableLimit));\n}\n\n/**\n * Generates prominent words from the given indexable data.\n *\n * @param {Object} indexableData The indexable data.\n * @param {Object} settings      The indexation settings.\n *\n * @returns {Promise[]} The prominent word generation promises.\n */\nfunction generateProminentWords(indexableData, settings) {\n\tvar data = [];\n\n\tindexableData.forEach(function (indexable) {\n\t\t// Generate the prominent words for an indexable.\n\t\tvar paper = new _yoastseo.Paper(indexable.content, {\n\t\t\tkeyword: indexable.meta.primary_focus_keyword || "",\n\t\t\tsynonyms: indexable.meta.keyphrase_synonyms || "",\n\t\t\ttitle: indexable.meta.title || "",\n\t\t\tdescription: indexable.meta.description || "",\n\t\t\tlocale: settings.locale || "en_US"\n\t\t});\n\n\t\tvar prominentWords = extractProminentWords(paper);\n\n\t\t// Save the prominent words for the request.\n\t\tdata.push({\n\t\t\t// eslint-disable-next-line camelcase\n\t\t\tobject_id: indexable.object_id,\n\t\t\t// eslint-disable-next-line camelcase\n\t\t\tobject_type: indexable.object_type,\n\t\t\t// eslint-disable-next-line camelcase\n\t\t\tprominent_words: prominentWords\n\t\t});\n\t});\n\n\treturn doAjaxRequest("POST", "" + settings.restApi.root + settings.prominentWords.endpoint, settings.restApi.nonce, { data: data });\n}\n\njQuery(function () {\n\twindow.yoast = window.yoast || {};\n\twindow.yoast.indexing = window.yoast.indexing || {};\n\tif (typeof window.yoast.indexing.registerPreIndexingAction === "function") {\n\t\twindow.yoast.indexing.registerPreIndexingAction("get_content", retrieveMorphologyData);\n\t}\n\tif (typeof window.yoast.indexing.registerIndexingAction === "function") {\n\t\twindow.yoast.indexing.registerIndexingAction("get_content", generateProminentWords);\n\t}\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///141\n')},142:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\n/**\n * Factory creating a language-specific researcher from the current window.\n */\nvar CurrentWindowResearcherFactory = function () {\n\tfunction CurrentWindowResearcherFactory() {\n\t\t_classCallCheck(this, CurrentWindowResearcherFactory);\n\t}\n\n\t_createClass(CurrentWindowResearcherFactory, null, [{\n\t\tkey: "create",\n\n\t\t/**\n  * Creates a language-specific researcher from the current window for the given paper\n  *\n  * @param {object} paper The paper to be analyzed.\n  *\n  * @returns {object} The researcher for the paper.\n  */\n\t\tvalue: function create(paper) {\n\t\t\t// eslint-disable-next-line new-cap\n\t\t\treturn new window.yoast.Researcher.default(paper);\n\t\t}\n\t}]);\n\n\treturn CurrentWindowResearcherFactory;\n}();\n\nexports.default = CurrentWindowResearcherFactory;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTQyLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vL2Fzc2V0cy9qcy9zcmMvZmFjdG9yaWVzL2N1cnJlbnQtd2luZG93LXJlc2VhcmNoZXItZmFjdG9yeS5qcz83YTNhIl0sInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogRmFjdG9yeSBjcmVhdGluZyBhIGxhbmd1YWdlLXNwZWNpZmljIHJlc2VhcmNoZXIgZnJvbSB0aGUgY3VycmVudCB3aW5kb3cuXG4gKi9cbmNsYXNzIEN1cnJlbnRXaW5kb3dSZXNlYXJjaGVyRmFjdG9yeSB7XG5cdC8qKlxuXHQqIENyZWF0ZXMgYSBsYW5ndWFnZS1zcGVjaWZpYyByZXNlYXJjaGVyIGZyb20gdGhlIGN1cnJlbnQgd2luZG93IGZvciB0aGUgZ2l2ZW4gcGFwZXJcblx0KlxuXHQqIEBwYXJhbSB7b2JqZWN0fSBwYXBlciBUaGUgcGFwZXIgdG8gYmUgYW5hbHl6ZWQuXG5cdCpcblx0KiBAcmV0dXJucyB7b2JqZWN0fSBUaGUgcmVzZWFyY2hlciBmb3IgdGhlIHBhcGVyLlxuXHQqL1xuXHRzdGF0aWMgY3JlYXRlKCBwYXBlciApIHtcblx0XHQvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbmV3LWNhcFxuXHRcdHJldHVybiBuZXcgd2luZG93LnlvYXN0LlJlc2VhcmNoZXIuZGVmYXVsdCggcGFwZXIgKTtcblx0fVxufVxuXG5leHBvcnQgZGVmYXVsdCBDdXJyZW50V2luZG93UmVzZWFyY2hlckZhY3Rvcnk7XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFBQTs7O0FBR0E7Ozs7Ozs7O0FBQ0E7Ozs7Ozs7QUFPQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7O0FBR0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///142\n')},18:function(module,exports){eval("module.exports = window.yoast.analysis;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTguanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cueW9hc3QuYW5hbHlzaXNcIj9jNDdjIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LnlvYXN0LmFuYWx5c2lzOyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///18\n")},2:function(module,exports){eval("module.exports = window.lodash;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMi5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy9leHRlcm5hbCBcIndpbmRvdy5sb2Rhc2hcIj9hNjAxIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LmxvZGFzaDsiXSwibWFwcGluZ3MiOiJBQUFBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///2\n")},35:function(module,exports){eval("module.exports = window.yoast.featureFlag;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMzUuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cueW9hc3QuZmVhdHVyZUZsYWdcIj84YTA3Il0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LnlvYXN0LmZlYXR1cmVGbGFnOyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///35\n")},41:function(module){eval('module.exports = {"name":"wordpress-seo-premium","license":"GPL-2.0+","description":"Development files for the Yoast SEO Premium plugin","plugin":{"glotpress":"http://translationspress.com","slug":"wordpress-seo-premium","textdomain":"wordpress-seo-premium"},"pot":{"reportmsgidbugsto":"https://github.com/yoast/wordpress-seo-premium/issues","languageteam":"Yoast Translate <translations@yoast.com>","lasttranslator":"Yoast Translate Team <translations@yoast.com>"},"repository":{"type":"git","url":"https://github.com/Yoast/wordpress-seo-premium"},"scripts":{"test":"jest -u assets/js/tests","build":"NODE_ENV=production webpack --config ./config/webpack/webpack.config.dev.js --progress --display-error-details","start":"webpack-dev-server --config ./config/webpack/webpack.config.dev.js --progress --env.environment=development --port=8081","webpack-analyze-bundle":"cross-env BUNDLE_ANALYZER=1 NODE_ENV=production webpack --config ./config/webpack/webpack.config.prod.js --progress","i18n-wordpress-seo-premium":"NODE_ENV=production babel assets/js/src --plugins=@wordpress/babel-plugin-makepot > /dev/null"},"jest":{"setupTestFrameworkScriptFile":"<rootDir>/assets/js/tests/setupTests.js","transformIgnorePatterns":["[/\\\\\\\\]node_modules[/\\\\\\\\](?!yoast-components|yoastseo|lodash-es|@yoast).+\\\\.js$"],"testPathIgnorePatterns":[],"moduleNameMapper":{"\\\\.(jpg|jpeg|png|gif|eot|otf|webp|svg|ttf|woff|woff2|mp4|webm|wav|mp3|m4a|aac|oga)$":"<rootDir>/asset/js/tests/__mocks__/file.js","\\\\.(css|less)$":"<rootDir>/assets/js/tests/__mocks__/style.js","find-with-regex":"<rootDir>/node_modules/find-with-regex/lib/index.js"},"moduleDirectories":["<rootDir>/node_modules","node_modules"],"snapshotSerializers":["enzyme-to-json/serializer"],"testURL":"http://localhost/"},"devDependencies":{"@types/react":"^17.0.3","@types/wordpress__blocks":"^6.4.12","@wordpress/babel-plugin-makepot":"^2.0.1","@wordpress/block-library":"^2.22.6","@wordpress/dependency-extraction-webpack-plugin":"^2.9.0","@yoast/grunt-plugin-tasks":"^2.1.2","@yoast/feature-flag":"^0.5.2","@yoast/schema-blocks":"link:vendor/yoast/wordpress-seo/packages/schema-blocks","babel-cli":"^6.26.0","babel-core":"^6.13.2","babel-plugin-transform-object-rest-spread":"^6.26.0","babel-plugin-transform-react-jsx":"^6.24.1","babel-preset-env":"^1.7.0","babel-preset-es2015":"^6.13.2","babel-preset-react":"^6.11.1","case-sensitive-paths-webpack-plugin":"^2.1.2","cross-env":"^7.0.2","css-loader":"^3.4.2","dotenv":"^8.2.0","envify":"^3.4.1","enzyme":"^3.3.0","enzyme-adapter-react-16":"^1.5.0","enzyme-to-json":"^3.3.3","eslint":"^6.6.0","find-with-regex":"~1.0.2","grunt-git":"^1.0.14","grunt-po2json":"^0.3.0","grunt-webpack":"^3.1.3","jest":"^23.3.0","jest-styled-components":"^6.3.4","prop-types":"^15.7.2","readline-sync":"^1.4.10","ts-loader":"^8.0.17","typescript":"^4.2.2","webpack":"^4.20.2","webpack-bundle-analyzer":"^4.2.0","webpack-cli":"^3.1.2","webpack-dev-server":"^3.1.14"},"dependencies":{"@yoast/social-metadata-previews":"link:vendor/yoast/wordpress-seo/packages/social-metadata-previews","a11y-speak":"github:yoast/a11y-speak","babel-loader":"^7.1.5","babel-plugin-dynamic-import-webpack":"^1.1.0","babel-polyfill":"^6.16.0","concat-map":"^0.0.1","grunt-glotpress":"https://github.com/Yoast/grunt-glotpress.git#translationspress","interpolate-components":"^1.1.0","lodash":"^4.7.0","sassdash":"^0.9.0","yoastseo":"^1.91.0"},"browserslist":["extends @yoast/browserslist-config"],"yoast":{"pluginVersion":"17.1.2"}};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDEuanMiLCJzb3VyY2VzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///41\n')},42:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n  value: true\n});\nexports.compressWordsForLinking = compressWordsForLinking;\n/**\n * Changes the given words from an array to an object.\n * This object maps the stems of the words to their occurrences.\n *\n * @param {ProminentWord[]} wordsForLinking The prominent words to compress.\n *\n * @returns {Object} Prominent words object with the stems as keys and the number of occurrences as values.\n */\nfunction compressWordsForLinking(wordsForLinking) {\n  var compressedWords = {};\n\n  wordsForLinking.forEach(function (word) {\n    compressedWords[word.getStem()] = word.getOccurrences();\n  });\n\n  return compressedWords;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDIuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vYXNzZXRzL2pzL3NyYy9oZWxwZXJzL2NvbXByZXNzV29yZHNGb3JMaW5raW5nLmpzPzYwM2EiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDaGFuZ2VzIHRoZSBnaXZlbiB3b3JkcyBmcm9tIGFuIGFycmF5IHRvIGFuIG9iamVjdC5cbiAqIFRoaXMgb2JqZWN0IG1hcHMgdGhlIHN0ZW1zIG9mIHRoZSB3b3JkcyB0byB0aGVpciBvY2N1cnJlbmNlcy5cbiAqXG4gKiBAcGFyYW0ge1Byb21pbmVudFdvcmRbXX0gd29yZHNGb3JMaW5raW5nIFRoZSBwcm9taW5lbnQgd29yZHMgdG8gY29tcHJlc3MuXG4gKlxuICogQHJldHVybnMge09iamVjdH0gUHJvbWluZW50IHdvcmRzIG9iamVjdCB3aXRoIHRoZSBzdGVtcyBhcyBrZXlzIGFuZCB0aGUgbnVtYmVyIG9mIG9jY3VycmVuY2VzIGFzIHZhbHVlcy5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGNvbXByZXNzV29yZHNGb3JMaW5raW5nKCB3b3Jkc0ZvckxpbmtpbmcgKSB7XG5cdGNvbnN0IGNvbXByZXNzZWRXb3JkcyA9IHt9O1xuXG5cdHdvcmRzRm9yTGlua2luZy5mb3JFYWNoKCBmdW5jdGlvbiggd29yZCApIHtcblx0XHRjb21wcmVzc2VkV29yZHNbIHdvcmQuZ2V0U3RlbSgpIF0gPSB3b3JkLmdldE9jY3VycmVuY2VzKCk7XG5cdH0gKTtcblxuXHRyZXR1cm4gY29tcHJlc3NlZFdvcmRzO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7OztBQVFBO0FBUkE7Ozs7Ozs7O0FBUUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///42\n')},43:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.determineMorphologyRequestUrl = determineMorphologyRequestUrl;\n\nvar _featureFlag = __webpack_require__(35);\n\n/**\n * Returns the correct URL for the morphology data request based on the language.\n *\n * @param {string} language The language for which to make a morphology data request.\n *\n * @returns {string|boolean} The URL for the morphology data request or false if the language doesn\'t have morphology support.\n */\nfunction determineMorphologyRequestUrl(language) {\n\tvar versions = {\n\t\ten: "v4",\n\t\tde: "v9",\n\t\tes: "v9",\n\t\tfr: "v9",\n\t\tit: "v10",\n\t\tnl: "v9",\n\t\tru: "v9",\n\t\tid: "v9",\n\t\tpt: "v9",\n\t\tpl: "v9",\n\t\tar: "v9",\n\t\tsv: "v1",\n\t\the: "v1",\n\t\thu: "v2",\n\t\tnb: "v1",\n\t\ttr: "v1",\n\t\tcs: "v1",\n\t\tsk: "v1"\n\t};\n\n\tif ((0, _featureFlag.isFeatureEnabled)("FARSI_SUPPORT")) {\n\t\tversions.fa = "v1";\n\t}\n\n\tif (!Object.keys(versions).includes(language)) {\n\t\treturn false;\n\t}\n\n\tvar baseRequestUrl = "https://my.yoast.com/api/downloads/file/morphology";\n\n\treturn baseRequestUrl + "-" + language + "-" + versions[language];\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vYXNzZXRzL2pzL3NyYy9oZWxwZXJzL2RldGVybWluZU1vcnBob2xvZ3lSZXF1ZXN0VXJsLmpzP2VhY2IiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgaXNGZWF0dXJlRW5hYmxlZCB9IGZyb20gXCJAeW9hc3QvZmVhdHVyZS1mbGFnXCI7XG5cbi8qKlxuICogUmV0dXJucyB0aGUgY29ycmVjdCBVUkwgZm9yIHRoZSBtb3JwaG9sb2d5IGRhdGEgcmVxdWVzdCBiYXNlZCBvbiB0aGUgbGFuZ3VhZ2UuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGxhbmd1YWdlIFRoZSBsYW5ndWFnZSBmb3Igd2hpY2ggdG8gbWFrZSBhIG1vcnBob2xvZ3kgZGF0YSByZXF1ZXN0LlxuICpcbiAqIEByZXR1cm5zIHtzdHJpbmd8Ym9vbGVhbn0gVGhlIFVSTCBmb3IgdGhlIG1vcnBob2xvZ3kgZGF0YSByZXF1ZXN0IG9yIGZhbHNlIGlmIHRoZSBsYW5ndWFnZSBkb2Vzbid0IGhhdmUgbW9ycGhvbG9neSBzdXBwb3J0LlxuICovXG5leHBvcnQgZnVuY3Rpb24gZGV0ZXJtaW5lTW9ycGhvbG9neVJlcXVlc3RVcmwoIGxhbmd1YWdlICkge1xuXHRjb25zdCB2ZXJzaW9ucyA9IHtcblx0XHRlbjogXCJ2NFwiLFxuXHRcdGRlOiBcInY5XCIsXG5cdFx0ZXM6IFwidjlcIixcblx0XHRmcjogXCJ2OVwiLFxuXHRcdGl0OiBcInYxMFwiLFxuXHRcdG5sOiBcInY5XCIsXG5cdFx0cnU6IFwidjlcIixcblx0XHRpZDogXCJ2OVwiLFxuXHRcdHB0OiBcInY5XCIsXG5cdFx0cGw6IFwidjlcIixcblx0XHRhcjogXCJ2OVwiLFxuXHRcdHN2OiBcInYxXCIsXG5cdFx0aGU6IFwidjFcIixcblx0XHRodTogXCJ2MlwiLFxuXHRcdG5iOiBcInYxXCIsXG5cdFx0dHI6IFwidjFcIixcblx0XHRjczogXCJ2MVwiLFxuXHRcdHNrOiBcInYxXCIsXG5cdH07XG5cblx0aWYgKCAgaXNGZWF0dXJlRW5hYmxlZCggXCJGQVJTSV9TVVBQT1JUXCIgKSApIHtcblx0XHR2ZXJzaW9ucy5mYSA9IFwidjFcIjtcblx0fVxuXG5cblx0aWYgKCAhIE9iamVjdC5rZXlzKCB2ZXJzaW9ucyApLmluY2x1ZGVzKCBsYW5ndWFnZSApICkge1xuXHRcdHJldHVybiBmYWxzZTtcblx0fVxuXG5cdGNvbnN0IGJhc2VSZXF1ZXN0VXJsID0gXCJodHRwczovL215LnlvYXN0LmNvbS9hcGkvZG93bmxvYWRzL2ZpbGUvbW9ycGhvbG9neVwiO1xuXG5cdHJldHVybiBgJHsgYmFzZVJlcXVlc3RVcmwgfS0keyBsYW5ndWFnZSB9LSR7IHZlcnNpb25zWyBsYW5ndWFnZSBdIH1gO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7OztBQVNBO0FBQ0E7QUFWQTtBQUNBO0FBQ0E7Ozs7Ozs7QUFPQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBbEJBO0FBQ0E7QUFvQkE7QUFDQTtBQUNBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///43\n')}},[[141,0]]]);